import numpy as np
from sklearn import datasets
from k_median_alg import K_median_alg
def test_median():
    points = np.array([[1, 2], [3, 2], [2, 4], [17, 12]])
    alg = K_median_alg(1, 1)
    best_center = alg.calculate_geometric_median(points)
    print(best_center)
    
def test_median_large():
    cov_type = datasets.fetch_covtype()
    points = cov_type.data
    data_subset = points[np.random.choice(points.shape[0], 100000, replace=False)]
    alg = K_median_alg(1, 1)
    center = alg.calculate_geometric_median(data_subset)
    print(center)

def test_fit():
    points = np.array([[1, 2], [3, 2], [2, 4], [17, 12]])
    alg = K_median_alg(2, 1)
    alg.fit(points)
    print(alg.centers)
    
def test_fit_large():
    cov_type = datasets.fetch_covtype()
    points = cov_type.data
    data_subset = points[np.random.choice(points.shape[0], 100000, replace=False)]
    alg = K_median_alg(2, 1)
    center = alg.calculate_geometric_median(data_subset)
    print(center)
